#include <stdint.h>

/*** macros/consts ***********************************************************/

//updated for halo

#define 	GPU2D_BASE_PTR					0x4004C000u
#define 	MC_CGM_AC1_SC					(*(volatile uint32_t *)(0x400D4000u+0x820)) 
#define 	MC_CGM_AC1_DC0					(*(volatile uint32_t *)(0x400D4000u+0x828)) 


void init_vybrid_twr_hw(void)
{
  // *** init halo HW ***
  /* CCM_CSCMR1:14 must be 0 to select PLL2 PFD2 clk (default) */
  //REG_SET_BFLD(CCM, &CCM_CSCDR2, CSCDR2, GPU_EN, 0x1);	/* Default GPU CLK = PLL2 PFD 2 (396MHz) */
  //CCM_CCGR8 = 0xFFFFFFFF;				/* enable GPU in clock gates */
  
  MC_CGM_AC1_SC = (4<<24); /* set PLL0 as source  */
  MC_CGM_AC1_DC0 = 0x80010000; /* divide by 2 */  
  
  //GICD_ISENABLER(2) = 0x00000004;			/* enable GPU interrupts to A5 GIC */

} // initVybridTwrHW()

uint32_t dec_peek(uint32_t address)
{
	return (*(uint32_t *)((uint32_t)GPU2D_BASE_PTR + address));
} // tiny_ui_hal_peek()

/*****************************************************************************/

void dec_poke(uint32_t address, uint32_t data)
{
	* (uint32_t *)((uint32_t)GPU2D_BASE_PTR + address) = data;
} // tiny_ui_hal_poke()
